<?php $__env->startSection('title','PCSOFT V4: Gestion magasin'); ?>
<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        <div class="col-12 col-sm-12 col-md-12 float-left">
            <div class="col-md-6 float-left">
                <h3 class="ml-5"><?php echo e(__('messages.GESTION DES MAGASINS')); ?></h3>
            </div>
            
        </div>

        <div class="col-12 col-sm-12 col-md-12">
            <div class="col-12 col-sm-3 col-md-3 float-left">
                <h3>Liste des Magasins</h3>
            </div>
            <div class="col-md-4 float-right">
                <button type="button" name="create_mag" id="create_mag" class="btn btn-success"><i class="fa fa-plus"></i> <?php echo e(__('messages.Nouveau magasin')); ?></button>
            </div>
        </div>
        <br>
        <br>
        <div class="info-box">
            <div class="table-responsive">
                <table id="liste_mag" class="table table-striped table-bordered data-table">
                    <thead>
                    <tr>
                        <th><?php echo e(__('messages.Libelle')); ?></th>
                        <th><?php echo e(__('messages.Type de magasin')); ?></th>
                        <th><?php echo e(__('messages.Actions')); ?></th>
                        <th><?php echo e(__('messages.Cout du magasin')); ?></th>
                        <th><?php echo e(__('messages.Etat du stock')); ?></th>
                    </tr>
                    </thead>
                </table>
            </div>

            <!--Ajouter un produit -->
            <div id="magasinModal" class="modal fade" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title"><?php echo e(__('messages.Creer un nouveau magasin')); ?></h4>
                        </div>
                        <div class="modal-body">
                            <span id="form_result"></span>
                            <form method="post" id="mag_form" class="form-horizontal">
                                <?php echo csrf_field(); ?>

                                <div class="form-group">
                                    <label class="control-label col-md-12" ><?php echo e(__('messages.Libelle')); ?> : </label>
                                    <input type="text" name="libelle" id="libelle" class="form-control" required="required"/>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-12" ><?php echo e(__('messages.Type de magasin')); ?> </label>
                                    <select name="type" id="type" class="form-control">
                                        <option value=""><?php echo e(__('messages.Selectionner un type')); ?></option>
                                        <option value="Magasin_Stockage"><?php echo e(__('messages.Magasin_Stockage')); ?></option>
                                        <option value="Stock_AEC"><?php echo e(__('messages.Stock_AEC')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group" align="center">
                                    <input type="hidden" name="magasin_id" id="magasin_id" />
                                    <input type="submit" name="action_button" id="action_button" class="btn btn-success" value="<?php echo e(__('messages.Enregistrer')); ?>" />
                                    <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Quitter')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!--Info stock -->
            <main id="coutstoskModal" class="modal fade" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2 class="modal-title"><?php echo e(__('messages.Confirmation')); ?></h2>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-12" ><?php echo e(__('messages.COUT MAGASIN')); ?> : </label>
                            <div class="col-md-12">
                                <input type="text" name="mag" id="mag" class="form-control" readonly/>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-12" ><?php echo e(__('messages.COUT DU STOCK')); ?> : </label>
                            <input type="text" name="cout_mag" id="cout_mag" class="form-control" readonly/>
                        </div>
                        <div class="form-group">
                            <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__('messages.Fermer')); ?></button>
                        </div>
                    </div>
                </div>
            </main>

            <!--Supprimer le magasin -->
            <main id="confirmModal" class="modal fade" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2 class="modal-title"><?php echo e(__('messages.Confirmation')); ?></h2>
                        </div>
                        <div class="modal-body">
                            <h5 align="center" style="margin:0;"><?php echo e(__('messages.Etes vous sure de supprimer ce magasin')); ?>?</h5>
                        </div>
                        <div class="modal-footer">
                            <button type="button" name="ok_button" id="ok_button" class="btn btn-danger"><?php echo e(__('messages.Oui')); ?></button>
                            <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__('messages.Annuler')); ?></button>
                        </div>
                    </div>
                </div>
            </main>

        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        $(document).ready(function(){

            $('#liste_mag').DataTable({
                processing: true,
                serverSide: true,
                ajax:{
                    url: "<?php echo e(route('mag.index')); ?>",
                },
                columns:[
                    {
                        data: 'libelle',
                        name: 'libelle'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false
                    },
                    {
                        data:'magasin_id',
                        name:'magasin_id',
                        render:function (data, type, row) {
                            return "<a href='#' id='"+row.magasin_id+"' class='btn btn-info cout_stock'><i class='fa fa-info'></i></a>"}
                    },
                    {
                        data:'magasin_id',
                        name:'magasin_id',
                        render:function (data, type, row) {
                            return "<a href='mag.stock/"+row.magasin_id+"' class='btn btn-success'><i class='fa fa-print'></i></a>"}
                    }
                ]
            });

            $('#create_mag').click(function(){
                $('.modal-title').text("<?php echo e(__('messages.Creer une magasin')); ?>");
                $('#action_button').val("<?php echo e(__('messages.Enregistrer')); ?>");
                $('#magasin_id').val('');
                $('#libelle').val('');
                $('#magasinModal').modal('show');
                $('#form_result').html('');
            });

            $('#mag_form').on('submit', function(event){
                event.preventDefault();
                $.ajax({
                    url:"<?php echo e(route('mag.store')); ?>",
                    method:"POST",
                    data: new FormData(this),
                    contentType: false,
                    cache:false,
                    processData: false,
                    dataType:"json",
                    success:function(data)
                    {
                        var html = '';
                        if(data.errors)
                        {
                            html = '<div class="alert alert-danger">';
                            for(var count = 0; count < data.errors.length; count++)
                            {
                                html += '<p>' + data.errors[count] + '</p>';
                            }
                            html += '</div>';
                        }
                        if(data.error)
                        {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if(data.success)
                        {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#mag_form')[0].reset();
                            $('#liste_mag').DataTable().ajax.reload();
                        }
                        $('#form_result').html(html);
                    }
                })
            });

            $(document).on('click', '.editer', function(){
                var id = $(this).attr('id');

                $('#form_result').html('');
                $.ajax({
                    url:"mag/"+id+"/edit",
                    dataType:"json",
                    success:function(data){
                        $('#libelle').val(data.libelle);
                        $('#type').val(data.type);
                        $('#magasin_id').val(id);
                        $('.modal-title').text("<?php echo e(__('messages.Editer une magasin')); ?>");
                        $('#action_button').val("<?php echo e(__('messages.Editer')); ?>");
                        $('#magasinModal').modal('show');
                    }
                })
            });

            $(document).on('click', '.cout_stock', function(){
                var id = $(this).attr('id');
                $('#coutstoskModal').html('');
                $.ajax({
                    url:"mag.cout_stock/"+id,
                    dataType:"json",
                    success:function(data){
                        $('#cout_mag').val(data.total);
                        $('#coutstoskModal').modal('show');
                    }
                })
            });


            var magasin_id;
            $(document).on('click', '.delete', function(){
                magasin_id = $(this).attr('id');
                $('.modal-title').text("<?php echo e(__('messages.Confirmation')); ?>");
                $('#ok_button').text('<?php echo e(__('messages.Oui')); ?>');
                $('#confirmModal').modal('show');
            });

            $('#ok_button').click(function(){
                $.ajax({
                    url:"mag.delete/"+magasin_id,
                    beforeSend:function(){
                        $('#ok_button').text('<?php echo e(__('messages.Suppression')); ?>...');
                    },
                    success:function(data)
                    {
                        setTimeout(function(){
                            $('#confirmModal').modal('hide');
                            $('#liste_mag').DataTable().ajax.reload();
                        }, 500);
                    }
                })
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/donnees/magasin/index.blade.php ENDPATH**/ ?>